/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.planning.mokos.conwip;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import cz.insophy.inplan.planning.mokos.Operation;
import cz.insophy.inplan.shop.Action;
import cz.insophy.inplan.shop.CapabilityIsland;
import cz.insophy.inplan.superplan.GeneralizedActionRequest;
import cz.insophy.inplan.superplan.GeneralizedOrderRequest;
import cz.insophy.inplan.superplan.ProductionTreeAlgorithms;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;

class GorWrapper
implements Comparable<GorWrapper> {
    private int order;
    private final GeneralizedOrderRequest gor;
    private final ImmutableMap<CapabilityIsland, Long> requestedNormtime;
    private final ImmutableMap<Operation, GarWrapper> operations;
    private boolean running;
    private CapabilityIsland lastBlockingIsland;
    private long authorizationTime;

    private GorWrapper(GeneralizedOrderRequest gor, ImmutableMap<CapabilityIsland, Long> requestedNormtime, ImmutableMap<Operation, GarWrapper> operations) {
        this.gor = gor;
        this.requestedNormtime = requestedNormtime;
        this.operations = operations;
    }

    public Set<CapabilityIsland> getCapabilityIslands() {
        return this.requestedNormtime.keySet();
    }

    public GarWrapper markGarAsFinished(Operation op) {
        GarWrapper gw = this.operations.get(op);
        gw.setFinished(true);
        return gw;
    }

    public boolean isFinished() {
        boolean finished = true;
        for (GarWrapper gaw : this.operations.values()) {
            finished &= gaw.isFinished();
        }
        return finished;
    }

    CapabilityIsland getLastBlockingIsland() {
        return this.lastBlockingIsland;
    }

    void setLastBlockingIsland(CapabilityIsland lastBlockingIsland) {
        this.lastBlockingIsland = lastBlockingIsland;
    }

    public Iterable<? extends Map.Entry<CapabilityIsland, Long>> getRequestedNormtimes() {
        return this.requestedNormtime.entrySet();
    }

    public boolean isRunning() {
        return this.running;
    }

    public void setRunning(boolean running) {
        this.running = running;
    }

    public Set<Operation> getOperations() {
        return this.operations.keySet();
    }

    public GeneralizedOrderRequest getGor() {
        return this.gor;
    }

    public void setAuthorizationTime(long authorizationTime) {
        this.authorizationTime = authorizationTime;
    }

    public long getAuthorizationTime() {
        return this.authorizationTime;
    }

    void setOrder(int order) {
        this.order = order;
    }

    @Nonnull
    public ImmutableCollection<GarWrapper> getGarWrappers() {
        return this.operations.values();
    }

    @Override
    public int compareTo(@Nonnull GorWrapper o) {
        return Integer.compare(this.order, o.order);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GorWrapper)) {
            return false;
        }
        GorWrapper that = (GorWrapper)o;
        return this.order == that.order;
    }

    public int hashCode() {
        return this.order;
    }

    public int getOrder() {
        return this.order;
    }

    private static void setWrappersOrder(List<GorWrapper> gws, Ordering<GorWrapper> gorOrdering) {
        Collections.sort(gws, gorOrdering);
        int i = 0;
        for (GorWrapper gw : gws) {
            gw.setOrder(i++);
        }
    }

    static Map<Operation, GorWrapper> buildWrappers(Set<Operation> ops, Ordering<GorWrapper> gorOrdering) {
        IdentityHashMap<Operation, GorWrapper> opGors = Maps.newIdentityHashMap();
        ArrayListMultimap<GeneralizedOrderRequest, Operation> gorOps = ArrayListMultimap.create();
        ArrayList<GorWrapper> gws = Lists.newArrayList();
        for (Operation operation : ops) {
            GeneralizedOrderRequest gor = ProductionTreeAlgorithms.getNearestGor(operation.getGar());
            gorOps.put(gor, operation);
        }
        for (Map.Entry entry : gorOps.asMap().entrySet()) {
            ArrayListMultimap<GeneralizedActionRequest, Operation> garOps = ArrayListMultimap.create();
            for (Operation op : (Collection)entry.getValue()) {
                garOps.put(op.getGar(), op);
            }
            ImmutableMap.Builder<Operation, GarWrapper> gaws = ImmutableMap.builder();
            IdentityHashMap<CapabilityIsland, Long> islandReqTimes = Maps.newIdentityHashMap();
            for (Map.Entry ent : garOps.asMap().entrySet()) {
                GarWrapper gaw = new GarWrapper((GeneralizedActionRequest)ent.getKey());
                Long reqNt = (Long)islandReqTimes.get(gaw.getIsland());
                reqNt = reqNt == null ? Long.valueOf(gaw.getRequestedNormtime()) : Long.valueOf(reqNt + gaw.getRequestedNormtime());
                islandReqTimes.put(gaw.getIsland(), reqNt);
                for (Operation op : ent.getValue()) {
                    gaws.put(op, gaw);
                }
            }
            ImmutableMap<Operation, GarWrapper> gawsz = gaws.build();
            GorWrapper gw = new GorWrapper((GeneralizedOrderRequest)entry.getKey(), ImmutableMap.copyOf(islandReqTimes), gawsz);
            for (Operation op : (Collection)entry.getValue()) {
                opGors.put(op, gw);
            }
            for (GarWrapper gaw : gawsz.values()) {
                gaw.setParent(gw);
            }
            gws.add(gw);
        }
        GorWrapper.setWrappersOrder(gws, gorOrdering);
        return opGors;
    }

    static class GarWrapper {
        private final GeneralizedActionRequest gar;
        private final CapabilityIsland island;
        private final long requestedNormtime;
        private GorWrapper parent;
        private boolean finished;

        public GarWrapper(GeneralizedActionRequest gar) {
            Action action = gar.getAction();
            this.requestedNormtime = action.normtime(gar.getAmount());
            this.island = gar.getSuperplan().getShopConf().getIsland(action.getCapabilityReq());
            this.gar = gar;
        }

        public GorWrapper getParent() {
            return this.parent;
        }

        private void setParent(GorWrapper parent) {
            this.parent = parent;
        }

        public CapabilityIsland getIsland() {
            return this.island;
        }

        public long getRequestedNormtime() {
            return this.requestedNormtime;
        }

        public void setFinished(boolean finished) {
            this.finished = finished;
        }

        public boolean isFinished() {
            return this.finished;
        }

        public GeneralizedActionRequest getGar() {
            return this.gar;
        }
    }
}

